* Kneitel_2010_algae_fdr1.sas; 
title 'Multiple comparisons for algae cover';
title2 'Data from Kneitel and Lessin (2010)';
data kneitel;
	input treat $ richness total algae;
	* Apply transformations here;
	y = arsin(sqrt(algae/100));
	datalines;
Control   8   78    1
Control   5   84    7
Control  10	 115   45
Control   7	 200  100
Control   6   72   20
Low       8   73   15
Low       7  124   70
Low       8  116   50
Low       8   92    5
Low       7  138   60
Medium    7  124   85
Medium    8  116   80
Medium    8  145   60
Medium    6  154  100
Medium    7  129   90
High      6  134   95
High      7  138   95
High      8  103   70
High      8  119   75
High      6  132   80
VeryHigh  6  148   95
VeryHigh  5  134   95
VeryHigh  5  119  100
VeryHigh  5  117   90
VeryHigh  5  129   80
;
run;
* Print data set;
proc print data=kneitel;
run;
* Plot means, standard errors, and observations;
proc gplot data=kneitel;
	plot y*treat=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* One-way ANOVA with comparisons;
proc glm plots=diagnostics data=kneitel;
	class treat;
	model y = treat;
	* LSD or Students t - only controls the per comparison error rate;
	lsmeans treat / adjust=t pdiff;
run;
quit;
